/*** 1.   ũƮ ***/
SELECT CASE WHEN LEFT(CONVERT(VARCHAR,a.number),1) <= 1 THEN 'A' ELSE 'B' END ID
	, CONVERT(VARCHAR,a.number) ProductNumber 
	, CONVERT(BIGINT,b.number)*100 AS Price 
	, CONVERT(date,DATEADD(DD,a.number+b.number,'2010-01-01'),0) ModifiedDate 
INTO TB_RIDLookup02
FROM master..spt_values a, (
	SELECT number 
	FROM master..spt_values 
	WHERE type ='P'
) b 
WHERE a.type = 'P'

CREATE NONCLUSTERED INDEX NIDX01_RIDLookup02 ON TB_RIDLookup02(ModifiedDate)
GO


/*** 2. [AS-IS] SQL    ȹ ***/
SELECT ProductNumber, Price, ModifiedDate 
FROM TB_RIDLookup02 
WHERE ModifiedDate IN ('2015-01-01', '2015-02-01')
GO


/*** 6. [TO-BE]   ***/

--ε  
DROP INDEX NIDX01_RIDLookup02 ON TB_RIDLookup02
CREATE CLUSTERED INDEX CIDX_RIDLookup02 ON TB_RIDLookup02(ModifiedDate) 
GO

--SQL 
SELECT ProductNumber, Price, ModifiedDate 
FROM TB_RIDLookup02 
WHERE ModifiedDate IN ('2015-01-01', '2015-02-01')
GO
